<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>PHOENIX LIFE - أطلق العنان لقوة مدخراتك</title>
    
    <!-- Tailwind CSS via CDN -->
    <script src="https://cdn.tailwindcss.com"></script>
    
    <!-- Google Fonts (Cairo for Arabic ) -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@400;700;900&display=swap" rel="stylesheet">

    <!-- Font Awesome for Icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">

    <style>
        /* --- Custom Styles --- */
        html { scroll-behavior: smooth; }
        body {
            font-family: 'Cairo', sans-serif;
            color: #E0E0E0; /* Softer white for better readability */
            background-color: #020a13; /* Deep dark blue background */
        }

        /* Video Background */
        #video-bg {
            position: fixed;
            top: 50%;
            left: 50%;
            min-width: 100%;
            min-height: 100%;
            width: auto;
            height: auto;
            z-index: -1;
            transform: translateX(-50% ) translateY(-50%);
            opacity: 0.15; /* Reduced opacity for better text visibility */
        }

        /* Glassmorphism Card Effect */
        .glass-card {
            background: rgba(10, 25, 47, 0.6); /* Darker glass */
            backdrop-filter: blur(20px);
            -webkit-backdrop-filter: blur(20px);
            border: 1px solid rgba(56, 189, 125, 0.2); /* Greenish border */
            transition: all 0.4s cubic-bezier(0.175, 0.885, 0.32, 1.275);
        }
        .glass-card:hover {
            transform: translateY(-15px) scale(1.02);
            border-color: rgba(56, 189, 125, 0.5);
        }

        /* Animation on Scroll */
        .scroll-reveal {
            opacity: 0;
            transform: translateY(50px);
            transition: opacity 0.8s ease-out, transform 0.8s ease-out;
        }
        .scroll-reveal.visible {
            opacity: 1;
            transform: translateY(0);
        }
        
        /* Language Toggle & Elements */
        [data-lang="en"] { display: none; }
        .lang-btn {
            background: rgba(10, 25, 47, 0.6);
            backdrop-filter: blur(10px);
            border: 1px solid rgba(56, 189, 125, 0.2);
        }
    </style>
</head>
<body class="antialiased">

    <!-- Video Background -->
    <video autoplay muted loop id="video-bg">
        <source src="https://cdn.pixabay.com/video/2022/10/20/135151-764038737_large.mp4" type="video/mp4">
        Your browser does not support the video tag.
    </video>

    <!-- Language Toggle Button -->
    <div class="fixed top-5 right-5 z-50">
        <button id="lang-toggle" class="lang-btn px-4 py-2 rounded-lg font-bold text-white hover:bg-green-400/20 transition-colors">
            English
        </button>
    </div>

    <!-- Hero Section -->
    <section class="min-h-screen flex flex-col justify-center items-center text-center px-4">
        <div class="scroll-reveal">
            <img src="https://i.ibb.co/ccs88VhD/PHOEN-X-L-FE.png" alt="PHOENIX LIFE Logo" class="w-40 h-40 md:w-52 md:h-52 mx-auto mb-6 drop-shadow-[0_0_15px_rgba(56,189,125,0.7 )]">
            
            <h1 class="text-5xl md:text-8xl font-black tracking-tighter text-white" data-lang="ar">أطلق العنان لقوة <span class="text-green-400">مدخراتك</span></h1>
            <h1 class="text-5xl md:text-8xl font-black tracking-tighter text-white" data-lang="en">Unleash the Power of <span class="text-green-400">Your Savings</span></h1>
            
            <p class="mt-6 text-lg md:text-2xl max-w-3xl mx-auto text-gray-300" data-lang="ar">مع PHOENIX LIFE، كل عملية شراء هي فرصة للتوفير. حوّل إنفاقك اليومي إلى مكافآت نقدية حقيقية.</p>
            <p class="mt-6 text-lg md:text-2xl max-w-3xl mx-auto text-gray-300" data-lang="en">With PHOENIX LIFE, every purchase is an opportunity to save. Turn your daily spending into real cash rewards.</p>
            
            <a href="#features" class="mt-10 inline-block bg-green-500 text-gray-900 font-bold text-xl px-10 py-4 rounded-full shadow-lg hover:bg-green-400 transform hover:scale-105 transition-all duration-300">
                <span data-lang="ar">اكتشف كيف</span>
                <span data-lang="en">Discover How</span>
            </a>
        </div>
    </section>

    <!-- Features Section -->
    <section id="features" class="py-20 px-4">
        <div class="container mx-auto">
            <div class="text-center mb-16 scroll-reveal">
                <h2 class="text-4xl md:text-6xl font-bold text-white" data-lang="ar">لماذا <span class="text-green-400">PHOENIX LIFE</span>؟</h2>
                <h2 class="text-4xl md:text-6xl font-bold text-white" data-lang="en">Why <span class="text-green-400">PHOENIX LIFE</span>?</h2>
                <p class="mt-4 text-xl text-gray-400" data-lang="ar">نحن أكثر من مجرد تطبيق كاش باك. نحن شريكك في التوفير الذكي.</p>
                <p class="mt-4 text-xl text-gray-400" data-lang="en">We're more than just a cashback app. We are your partner in smart savings.</p>
            </div>
            <div class="grid grid-cols-1 md:grid-cols-3 gap-10">
                <div class="glass-card p-8 rounded-2xl text-center scroll-reveal" style="transition-delay: 200ms;">
                    <i class="fas fa-store text-5xl text-green-400 mb-6"></i>
                    <h3 class="text-2xl font-bold mb-3 text-white" data-lang="ar">شبكة واسعة من المتاجر</h3>
                    <h3 class="text-2xl font-bold mb-3 text-white" data-lang="en">Vast Store Network</h3>
                    <p class="text-gray-300" data-lang="ar">احصل على كاش باك من مئات العلامات التجارية المحلية والعالمية التي تحبها وتثق بها.</p>
                    <p class="text-gray-300" data-lang="en">Get cashback from hundreds of local and international brands you love and trust.</p>
                </div>
                <div class="glass-card p-8 rounded-2xl text-center scroll-reveal" style="transition-delay: 400ms;">
                    <i class="fas fa-wallet text-5xl text-green-400 mb-6"></i>
                    <h3 class="text-2xl font-bold mb-3 text-white" data-lang="ar">مكافآت حقيقية وسهلة</h3>
                    <h3 class="text-2xl font-bold mb-3 text-white" data-lang="en">Real & Easy Rewards</h3>
                    <p class="text-gray-300" data-lang="ar">لا نقاط، لا قسائم معقدة. فقط أموال نقدية حقيقية يمكنك سحبها أو استخدامها كما تشاء.</p>
                    <p class="text-gray-300" data-lang="en">No points, no complicated vouchers. Just real cash you can withdraw or use as you wish.</p>
                </div>
                <div class="glass-card p-8 rounded-2xl text-center scroll-reveal" style="transition-delay: 600ms;">
                    <i class="fas fa-shield-halved text-5xl text-green-400 mb-6"></i>
                    <h3 class="text-2xl font-bold mb-3 text-white" data-lang="ar">آمن وموثوق</h3>
                    <h3 class="text-2xl font-bold mb-3 text-white" data-lang="en">Secure & Trusted</h3>
                    <p class="text-gray-300" data-lang="ar">أمان بياناتك هو أولويتنا القصوى. نحن نستخدم أفضل معايير الحماية لضمان خصوصيتك.</p>
                    <p class="text-gray-300" data-lang="en">Your data security is our top priority. We use the best protection standards to ensure your privacy.</p>
                </div>
            </div>
        </div>
    </section>

<!-- ========================================================== -->
<!-- START: NEW AND EXPANDED LEGAL SECTION                      -->
<!-- ========================================================== -->
<section id="legal" class="py-20 px-4">
    <div class="container mx-auto max-w-6xl"> <!-- Increased max-width for more space -->
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-12"> <!-- Increased gap -->
            
            <!-- Privacy Policy Card -->
            <div class="glass-card rounded-2xl p-8 md:p-10 scroll-reveal">
                <div class="flex items-center mb-6">
                    <i class="fas fa-user-shield text-4xl text-green-400 mr-4"></i>
                    <div>
                        <h2 class="text-3xl font-bold text-white" data-lang="ar">سياسة الخصوصية</h2>
                        <h2 class="text-3xl font-bold text-white" data-lang="en">Privacy Policy</h2>
                        <p class="text-sm text-gray-400" data-lang="ar">آخر تحديث: 11 نوفمبر 2025</p>
                        <p class="text-sm text-gray-400" data-lang="en">Last Updated: November 11, 2025</p>
                    </div>
                </div>

                <!-- Arabic Text -->
                <div class="space-y-4 text-lg text-gray-300" data-lang="ar">
                    <p>في PHOENIX LIFE، نحن نؤمن بأن الثقة هي أساس علاقتنا مع مستخدمينا. خصوصيتك ليست مجرد متطلب قانوني، بل هي التزام أخلاقي من طرفنا. توضح هذه السياسة بالتفصيل أنواع البيانات التي نجمعها، وكيفية استخدامها لتقديم خدمة استرداد نقدي سلسة وآمنة.</p>
                    <h4 class="font-bold text-green-300 pt-2">1. البيانات التي نجمعها:</h4>
                    <ul class="list-disc list-inside space-y-2 pr-4">
                        <li><strong>بيانات الحساب:</strong> الاسم، البريد الإلكتروني، ومعلومات التعريف الأساسية لإنشاء وإدارة حسابك.</li>
                        <li><strong>بيانات المعاملات:</strong> عند التسوق عبر شركائنا، نتلقى بيانات غير شخصية مثل معرّف الطلب، قيمة الشراء، وتاريخ المعاملة. هذه البيانات ضرورية لتتبع وحساب قيمة الاسترداد النقدي المستحق لك.</li>
                        <li><strong>بيانات تقنية:</strong> معلومات عن جهازك ونظام التشغيل لتحسين أداء التطبيق وإصلاح المشاكل التقنية.</li>
                    </ul>
                    <h4 class="font-bold text-green-300 pt-2">2. كيف نستخدم بياناتك:</h4>
                    <p>يتم استخدام بياناتك حصراً للأغراض التالية: تفعيل وتأكيد الاسترداد النقدي، إدارة رصيدك، تحسين تجربة استخدامك للتطبيق، والتواصل معك بشأن التحديثات الهامة المتعلقة بحسابك. نحن نتعهد بشكل قاطع بعدم بيع أو تأجير أو مشاركة معلوماتك الشخصية التعريفية مع أي جهة خارجية لأغراض الدعاية أو التسويق.</p>
                    <h4 class="font-bold text-green-300 pt-2">3. أمان البيانات:</h4>
                    <p>نحن نستخدم بروتوكولات تشفير متقدمة (مثل SSL/TLS) لحماية البيانات أثناء نقلها، ونطبق أفضل الممارسات الأمنية لحماية قواعد بياناتنا. الوصول إلى بياناتك مقيد ومحصور فقط بالموظفين المصرح لهم والذين يحتاجونها لتقديم الدعم الفني.</p>
                    <p class="mt-4">لأي استفسارات تتعلق بخصوصيتك، لا تتردد في التواصل مع مسؤول حماية البيانات لدينا عبر: <a href="mailto:info@phoenixlife.app" class="underline hover:text-green-300">info@phoenixlife.app</a></p>
                </div>

                <!-- English Text -->
                <div class="space-y-4 text-lg text-gray-300" data-lang="en">
                    <p>At PHOENIX LIFE, we believe that trust is the foundation of our relationship with our users. Your privacy is not just a legal requirement but our ethical commitment. This policy details the types of data we collect and how it is used to provide a seamless and secure cashback service.</p>
                    <h4 class="font-bold text-green-300 pt-2">1. Data We Collect:</h4>
                    <ul class="list-disc list-inside space-y-2 pl-4">
                        <li><strong>Account Data:</strong> Name, email, and basic identification information to create and manage your account.</li>
                        <li><strong>Transaction Data:</strong> When you shop with our partners, we receive non-personal data such as order ID, purchase value, and transaction date. This data is essential for tracking and calculating your due cashback.</li>
                        <li><strong>Technical Data:</strong> Information about your device and operating system to improve app performance and resolve technical issues.</li>
                    </ul>
                    <h4 class="font-bold text-green-300 pt-2">2. How We Use Your Data:</h4>
                    <p>Your data is used exclusively for the following purposes: activating and confirming cashback, managing your balance, enhancing your app experience, and communicating important updates regarding your account. We unequivocally pledge not to sell, rent, or share your personally identifiable information with any third party for advertising or marketing purposes.</p>
                    <h4 class="font-bold text-green-300 pt-2">3. Data Security:</h4>
                    <p>We use advanced encryption protocols (like SSL/TLS) to protect data in transit and apply best security practices to safeguard our databases. Access to your data is restricted and limited only to authorized personnel who require it for technical support.</p>
                    <p class="mt-4">For any inquiries regarding your privacy, do not hesitate to contact our Data Protection Officer at: <a href="mailto:info@phoenixlife.app" class="underline hover:text-green-300">info@phoenixlife.app</a></p>
                </div>
            </div>

            <!-- Terms of Service Card -->
            <div class="glass-card rounded-2xl p-8 md:p-10 scroll-reveal" style="transition-delay: 200ms;">
                <div class="flex items-center mb-6">
                    <i class="fas fa-file-signature text-4xl text-green-400 mr-4"></i>
                    <div>
                        <h2 class="text-3xl font-bold text-white" data-lang="ar">شروط الخدمة</h2>
                        <h2 class="text-3xl font-bold text-white" data-lang="en">Terms of Service</h2>
                        <p class="text-sm text-gray-400" data-lang="ar">آخر تحديث: 11 نوفمبر 2025</p>
                        <p class="text-sm text-gray-400" data-lang="en">Last Updated: November 11, 2025</p>
                    </div>
                </div>
                
                <!-- Arabic Text -->
                <div class="space-y-4 text-lg text-gray-300" data-lang="ar">
                    <p>مرحباً بك في PHOENIX LIFE. باستخدامك لخدماتنا، فإنك توافق على الالتزام بهذه الشروط التي تضمن بيئة عادلة وموثوقة لجميع المستخدمين. يرجى قراءتها بعناية.</p>
                    <h4 class="font-bold text-green-300 pt-2">1. طبيعة الخدمة:</h4>
                    <p>PHOENIX LIFE هي منصة وسيطة تتيح للمستخدمين الحصول على استرداد نقدي (كاش باك) على المشتريات المؤهلة من المتاجر الشريكة. نحن لا نبيع المنتجات مباشرة، بل نوجهك إلى مواقع المتاجر. مسؤولية جودة المنتج والشحن والضمان تقع على عاتق المتجر البائع.</p>
                    <h4 class="font-bold text-green-300 pt-2">2. حساب الاسترداد النقدي:</h4>
                    <p>يتم حساب قيمة الاسترداد النقدي كنسبة مئوية من صافي قيمة الشراء (بعد استثناء الضرائب ورسوم الشحن). هذه النسب يتم تحديدها وتحديثها من قبل شركائنا وقد تتغير. الرصيد يظهر في حسابك كـ "معلق" حتى يتم تأكيده من قبل المتجر بعد انقضاء فترة الإرجاع والاستبدال، وهي عملية قد تستغرق من 30 إلى 90 يوماً.</p>
                    <h4 class="font-bold text-green-300 pt-2">3. سحب الأرصدة:</h4>
                    <p>يمكنك طلب سحب رصيدك "المؤكد" عند الوصول إلى الحد الأدنى للسحب الموضح في التطبيق. تتم معالجة طلبات السحب خلال فترة زمنية محددة. قد تخضع عمليات السحب لرسوم معالجة بسيطة من قبل مزودي الخدمة المالية، وسيتم توضيح ذلك قبل تأكيد عملية السحب.</p>
                    <h4 class="font-bold text-green-300 pt-2">4. الاستخدام العادل وإنهاء الخدمة:</h4>
                    <p>تم تصميم الخدمة للاستخدام الشخصي والنزيه. يُمنع منعاً باتاً استخدام أي وسائل آلية أو برمجيات احتيالية للتلاعب بالخدمة. تحتفظ PHOENIX LIFE بالحق الكامل في مراجعة أي حساب، وتعديل الأرصدة، أو تعليق الحسابات التي يُشتبه في قيامها بنشاطات مخالفة أو احتيالية، وذلك لضمان نزاهة المنصة لجميع المستخدمين.</p>
                </div>

                <!-- English Text -->
                <div class="space-y-4 text-lg text-gray-300" data-lang="en">
                    <p>Welcome to PHOENIX LIFE. By using our services, you agree to be bound by these terms, which ensure a fair and reliable environment for all users. Please read them carefully.</p>
                    <h4 class="font-bold text-green-300 pt-2">1. Nature of the Service:</h4>
                    <p>PHOENIX LIFE is an intermediary platform that allows users to earn cashback on eligible purchases from partner stores. We do not sell products directly but redirect you to store websites. Responsibility for product quality, shipping, and warranty lies with the selling store.</p>
                    <h4 class="font-bold text-green-300 pt-2">2. Cashback Calculation:</h4>
                    <p>Cashback is calculated as a percentage of the net purchase value (excluding taxes and shipping fees). These rates are determined and updated by our partners and may change. The balance appears in your account as "pending" until confirmed by the store after the return and exchange period has passed, a process that may take 30 to 90 days.</p>
                    <h4 class="font-bold text-green-300 pt-2">3. Withdrawing Balances:</h4>
                    <p>You can request to withdraw your "confirmed" balance upon reaching the minimum withdrawal threshold specified in the app. Withdrawal requests are processed within a specified timeframe. Withdrawals may be subject to minor processing fees by financial service providers, which will be clarified before you confirm the withdrawal.</p>
                    <h4 class="font-bold text-green-300 pt-2">4. Fair Use & Termination:</h4>
                    <p>The service is designed for personal and fair use. The use of any automated means or fraudulent software to manipulate the service is strictly prohibited. PHOENIX LIFE reserves the full right to review any account, adjust balances, or suspend accounts suspected of engaging in violating or fraudulent activities, to ensure the integrity of the platform for all users.</p>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- ========================================================== -->
<!-- END: NEW AND EXPANDED LEGAL SECTION                        -->
<!-- ========================================================== -->


    <!-- Footer -->
    <footer class="text-center py-10 border-t border-white/10">
        <p class="text-gray-400">&copy; 2025 PHOENIX LIFE. كل الحقوق محفوظة.</p>
        <a href="https://phoenixlife.app" class="underline text-gray-400 hover:text-green-300">phoenixlife.app</a>
    </footer>

    <script>
        // JavaScript for Animations and Language Toggle
        document.addEventListener("DOMContentLoaded", function( ) {
            // Animation on scroll
            const observer = new IntersectionObserver(entries => {
                entries.forEach(entry => {
                    if (entry.isIntersecting) {
                        entry.target.classList.add('visible');
                        observer.unobserve(entry.target); // Optional: stop observing after animation
                    }
                });
            }, { threshold: 0.2 });

            document.querySelectorAll('.scroll-reveal').forEach(elem => {
                observer.observe(elem);
            });

            // Language Toggle
            const toggleBtn = document.getElementById('lang-toggle');
            const htmlEl = document.documentElement;
            const arElements = document.querySelectorAll('[data-lang="ar"]');
            const enElements = document.querySelectorAll('[data-lang="en"]');

            toggleBtn.addEventListener('click', () => {
                if (htmlEl.lang === 'ar') {
                    // Switch to English
                    htmlEl.lang = 'en';
                    htmlEl.dir = 'ltr';
                    toggleBtn.textContent = 'العربية';
                    arElements.forEach(el => el.style.display = 'none');
                    enElements.forEach(el => el.style.display = 'block');
                } else {
                    // Switch to Arabic
                    htmlEl.lang = 'ar';
                    htmlEl.dir = 'rtl';
                    toggleBtn.textContent = 'English';
                    enElements.forEach(el => el.style.display = 'none');
                    arElements.forEach(el => el.style.display = 'block');
                }
            });
        });
    </script>

</body>
</html>
<?php /**PATH /home/azzuncgk/phoenixlife.app/resources/views/welcome.blade.php ENDPATH**/ ?>