<?php

// 1. الاستيرادات الصحيحة والمنظمة
use App\Http\Controllers\Api\V1\Admin\AdminDashboardController;
use App\Http\Controllers\Api\V1\Admin\AdminProductController;
use App\Http\Controllers\Api\V1\Admin\StoreReportController;
use App\Http\Controllers\Api\V1\Admin\UserController as AdminUserController;
use App\Http\Controllers\Api\V1\Admin\UserReportController;
use App\Http\Controllers\Api\V1\Admin\WithdrawalController as AdminWithdrawalController;
use App\Http\Controllers\Api\V1\AuthController;
use App\Http\Controllers\Api\V1\OfferController;
use App\Http\Controllers\Api\V1\Store\CashbackController as StoreCashbackController;
use App\Http\Controllers\Api\V1\Store\StoreDashboardController;
use App\Http\Controllers\Api\V1\Store\ProductController as StoreProductController;
use App\Http\Controllers\Api\V1\Store\ProfileController as StoreProfileController;
use App\Http\Controllers\Api\V1\UserController;
use App\Http\Controllers\Api\V1\Admin\ProfileUpdateRequestController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\Auth\PasswordResetController; // قم بإنشاء هذا الـ Controller

/*
|--------------------------------------------------------------------------
| API Routes V1
|--------------------------------------------------------------------------
*/

// =================================================================
// 1. Public Routes
// =================================================================
Route::prefix('v1')->group(function () {
    Route::post('/forgot-password', [PasswordResetController::class, 'sendResetLink']);
    Route::post('/reset-password', [PasswordResetController::class, 'resetPassword']);
    Route::post('/auth/register', [AuthController::class, 'register']);
    Route::post('/auth/login', [AuthController::class, 'login']);
    Route::get('/offers', [OfferController::class, 'index']);
    Route::get('/categories', [OfferController::class, 'getCategories']);
    Route::get('/countries', [OfferController::class, 'getCountries']);
    Route::get('/cities', [OfferController::class, 'getCities']);
    Route::get('/offers/{storeId}', [OfferController::class, 'show']);
});

// =================================================================
// 2. Authenticated User Routes
// =================================================================
Route::middleware(['auth:sanctum'])->prefix('v1')->group(function () {
    Route::post('/auth/logout', [AuthController::class, 'logout']);

    Route::get('/user', function (Request $request) {
        $user = $request->user();
        $relations = ['wallet', 'referrer', 'referrals'];
        if ($request->has('with') && $request->query('with') == 'storeProfile') {
            $relations[] = 'storeProfile';
        }
        return $user->load($relations);
    });

    Route::get('/transactions', [UserController::class, 'transactions']);
    Route::post('/withdrawals/request', [UserController::class, 'requestWithdrawal']);
    Route::get('/notifications', [UserController::class, 'getNotifications']);
    Route::post('/user/update', [UserController::class, 'updateProfile']);
});

// =================================================================
// 3. Admin Routes (تم تصحيحه بالكامل)
// =================================================================
Route::middleware(['auth:sanctum', 'auth.admin'])->prefix('v1/admin')->group(function () {
    Route::get('/dashboard-stats', [AdminDashboardController::class, 'getStats']);
    Route::get('/users', [AdminUserController::class, 'index']);
    Route::post('/users/{user}/approve', [AdminUserController::class, 'approve']);
    Route::post('/users/{user}/toggle-status', [AdminUserController::class, 'toggleUserStatus']);
    Route::post('/users/{user}/adjust-balance', [AdminUserController::class, 'adjustBalance']);
    Route::get('/stores', [AdminUserController::class, 'getStores']);
    Route::post('/stores', [AdminUserController::class, 'createStore']);
    Route::post('/stores/{user}', [AdminUserController::class, 'updateStore']);
    Route::post('/stores/{user}/toggle-status', [AdminUserController::class, 'toggleStoreStatus']);
    Route::delete('/stores/{user}', [AdminUserController::class, 'deleteStore']);
    Route::get('/stores/update-requests', [AdminUserController::class, 'getUpdateRequests']);
    Route::post('/stores/update-requests/{updateRequest}/process', [AdminUserController::class, 'processUpdateRequest']);
    Route::get('/stores/{user}/products', [AdminUserController::class, 'getStoreProducts']);
    Route::post('/stores/{store}/products', [AdminProductController::class, 'store']);
    Route::put('/products/{product}', [AdminProductController::class, 'update']);
    Route::delete('/products/{product}', [AdminProductController::class, 'destroy']);
    Route::get('/withdrawals', [AdminWithdrawalController::class, 'index']);
    Route::post('/withdrawals/{withdrawalRequest}/process', [AdminWithdrawalController::class, 'process']);
    Route::get('/users/{user}/report', [UserReportController::class, 'getUserReport']);
    
    // **الإصلاح الحاسم هنا: استخدام {user}**
    Route::get('/stores/{user}/report', [StoreReportController::class, 'getStoreReport']);
    
    Route::delete('/transactions/{transaction}', [StoreReportController::class, 'destroyTransaction']);
    Route::delete('/stores/{user}/clear-invoices', [StoreReportController::class, 'clearStoreInvoices']);

    // **الإصلاح الحاسم هنا: استخدام {user}**
    Route::delete('/stores/{user}/transactions', [StoreReportController::class, 'clearTransactions']);
    
    Route::get('/filters/categories', [AdminUserController::class, 'getFilterCategories']);
    Route::get('/filters/cities', [AdminUserController::class, 'getFilterCities']);
    Route::get('/data/categories', [AdminUserController::class, 'getAdminCategories']);
    Route::get('/data/countries', [AdminUserController::class, 'getAdminCountries']);
    Route::get('/invoices', [StoreReportController::class, 'getAllInvoices']);
    Route::get('/invoices/{invoice}', [StoreReportController::class, 'getInvoiceDetails']);
    Route::delete('/invoices/{invoice}', [StoreReportController::class, 'destroyInvoice']);

    Route::get('update-requests', [ProfileUpdateRequestController::class, 'index']);
    Route::get('update-requests/{updateRequest}', [ProfileUpdateRequestController::class, 'show']);
    Route::post('update-requests/{updateRequest}/process', [ProfileUpdateRequestController::class, 'process']);
});

// =================================================================
// 4. Store Routes (تم تنظيفه)
// =================================================================
Route::middleware(['auth:sanctum', 'auth.store'])->prefix('v1/store')->group(function () {
    Route::get('/dashboard', [StoreProductController::class, 'getDashboardData']);
    Route::get('/profile', [StoreProfileController::class, 'show']);
    Route::post('/profile/request-update', [StoreProfileController::class, 'requestUpdate']);
    
    Route::get('/products', [StoreProductController::class, 'index']);
    Route::post('/products', [StoreProductController::class, 'store']);
    Route::post('/products/{product}', [StoreProductController::class, 'update']); // **هذا هو الرابط الحاسم**
    Route::delete('/products/{product}', [StoreProductController::class, 'destroy']);

    Route::post('/products/update-all-cashback', [StoreProductController::class, 'updateAllProductsCashback']);
    Route::post('/cashback/process', [StoreCashbackController::class, 'processCashback']);
	Route::get('/invoices/{invoice}', [StoreReportController::class, 'getInvoiceDetails']);
    Route::get('/store/report', [App\Http\Controllers\Api\V1\Store\ReportController::class, 'getStoreReport']);
});



Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    // **الإصلاح الحاسم هنا: إضافة علاقة 'referrer' لجلب اسم المُحيل**
    return $request->user()->load('storeProfile', 'referrer');
});