<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>PHOENIX LIFE - طلب حذف الحساب</title>
    
    <!-- Tailwind CSS via CDN -->
    <script src="https://cdn.tailwindcss.com"></script>
    
    <!-- Google Fonts (Cairo ) -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@400;700;900&display=swap" rel="stylesheet">

    <!-- Font Awesome for Icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">

    <style>
        body {
            font-family: 'Cairo', sans-serif;
            color: #E0E0E0;
            background-color: #020a13;
        }
        #video-bg {
            position: fixed; top: 50%; left: 50%; min-width: 100%; min-height: 100%;
            width: auto; height: auto; z-index: -1; transform: translateX(-50% ) translateY(-50%);
            opacity: 0.15;
        }
        .glass-card {
            background: rgba(10, 25, 47, 0.7);
            backdrop-filter: blur(20px);
            -webkit-backdrop-filter: blur(20px);
            border: 1px solid rgba(56, 189, 125, 0.2);
        }
    </style>
</head>
<body class="antialiased">

    <!-- Video Background -->
    <video autoplay muted loop id="video-bg">
        <source src="https://cdn.pixabay.com/video/2022/10/20/135151-764038737_large.mp4" type="video/mp4">
    </video>

    <div class="min-h-screen flex flex-col justify-center items-center px-4 py-12">
        <div class="w-full max-w-3xl mx-auto">
            
            <!-- Main Card -->
            <div class="glass-card rounded-2xl p-8 md:p-12 text-center">
                
                <img src="https://i.ibb.co/ccs88VhD/PHOEN-X-L-FE.png" alt="PHOENIX LIFE Logo" class="w-24 h-24 mx-auto mb-6">
                
                <h1 class="text-4xl md:text-5xl font-black text-white">طلب حذف الحساب</h1>
                <p class="mt-4 text-lg text-gray-300">نحن نأسف لرغبتك في المغادرة. يرجى العلم بأن هذه العملية نهائية ولا يمكن التراجع عنها.</p>

                <div class="my-8 border-t border-white/10"></div>

                <div class="text-right space-y-4 text-lg">
                    <h2 class="font-bold text-2xl text-green-400 mb-4">ماذا يعني حذف حسابك؟</h2>
                    <ul class="list-disc list-inside space-y-3 pr-4">
                        <li>سيتم حذف جميع بياناتك الشخصية بشكل دائم من أنظمتنا.</li>
                        <li>ستفقد أي رصيد كاش باك متبقٍ في حسابك (سواء كان معلقاً أو مؤكداً ).</li>
                        <li>لن تتمكن من الوصول إلى سجل مشترياتك أو مكافآتك السابقة.</li>
                        <li>سيتم إلغاء ربط حسابك بجميع المتاجر الشريكة.</li>
                    </ul>
                </div>

                <div class="my-8 border-t border-white/10"></div>

                <div>
                    <h2 class="font-bold text-2xl text-green-400 mb-4">لتقديم طلب الحذف</h2>
                    <p class="text-lg text-gray-300 mb-6">
                        لتأكيد هويتك وحماية بياناتك، يرجى إرسال طلب الحذف من البريد الإلكتروني المسجل به حسابك إلى فريق الدعم الفني لدينا.
                    </p>
                    
                    <div class="space-y-4 text-left">
                        <!-- Email Support -->
                        <div class="flex items-center glass-card p-4 rounded-lg">
                            <i class="fas fa-envelope text-2xl text-green-400 w-8"></i>
                            <div class="ml-4">
                                <span class="font-bold text-white">البريد الإلكتروني للدعم:</span>
                                <a href="mailto:info@phoenixlife.app" class="block text-gray-300 hover:text-green-300 transition">info@phoenixlife.app</a>
                            </div>
                        </div>
                        
                        <!-- WhatsApp Support -->
                        <div class="flex items-center glass-card p-4 rounded-lg">
                            <i class="fab fa-whatsapp text-3xl text-green-400 w-8"></i>
                            <div class="ml-4">
                                <span class="font-bold text-white">دعم الواتساب:</span>
                                <a href="https://wa.me/963994367721" target="_blank" class="block text-gray-300 hover:text-green-300 transition" dir="ltr">+963 937 059 767</a>
                            </div>
                        </div>

                        <!-- Phone Support -->
                        <div class="flex items-center glass-card p-4 rounded-lg">
                            <i class="fas fa-phone-alt text-2xl text-green-400 w-8"></i>
                            <div class="ml-4">
                                <span class="font-bold text-white">الدعم الهاتفي:</span>
                                <a href="tel:+963994367721" class="block text-gray-300 hover:text-green-300 transition" dir="ltr">+963 937 059 767</a>
                            </div>
                        </div>
                    </div>
                    <p class="mt-6 text-sm text-gray-400">سيقوم فريقنا بمعالجة طلبك خلال 72 ساعة عمل.</p>
                </div>

            </div>

            <!-- Back to Home -->
            <div class="text-center mt-8">
                <a href="/" class="text-gray-300 hover:text-white hover:underline transition">العودة إلى الصفحة الرئيسية</a>
            </div>
        </div>
    </div>

</body>
</html>
