<?php

namespace Database\Seeders;

use App\Models\Category;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Schema; // <-- أضف هذا السطر

class CategorySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // ================== الحل هنا ==================
        // 1. تعطيل فحص القيود الأجنبية
        Schema::disableForeignKeyConstraints();

        // 2. تفريغ الجدول بأمان
        Category::truncate();

        // 3. إعادة تفعيل فحص القيود الأجنبية
        Schema::enableForeignKeyConstraints();
        // ============================================

        $categories = [
            // ... (قائمة الفئات الطويلة تبقى كما هي) ...
            ['name' => 'مطاعم'],
            ['name' => 'مقاهي وكافيهات'],
            ['name' => 'وجبات سريعة'],
            ['name' => 'حلويات ومخابز'],
            ['name' => 'عصائر وآيس كريم'],
            ['name' => 'ملابس وأزياء'],
            ['name' => 'أحذية وحقائب'],
            ['name' => 'مجوهرات وساعات'],
            ['name' => 'عطور ومستحضرات تجميل'],
            ['name' => 'نظارات وبصريات'],
            ['name' => 'ملابس أطفال'],
            ['name' => 'صيدليات'],
            ['name' => 'مراكز تجميل وصالونات'],
            ['name' => 'نوادي رياضية (جيم)'],
            ['name' => 'عيادات طبية'],
            ['name' => 'مراكز سبا وعناية'],
            ['name' => 'إلكترونيات وجوالات'],
            ['name' => 'أجهزة منزلية'],
            ['name' => 'كمبيوتر ومستلزماته'],
            ['name' => 'أثاث وديكور'],
            ['name' => 'مستلزمات مكتبية وقرطاسية'],
            ['name' => 'مستلزمات مطبخ'],
            ['name' => 'سينما وفعاليات'],
            ['name' => 'ألعاب وهدايا'],
            ['name' => 'كتب ومجلات'],
            ['name' => 'مراكز ترفيهية للأطفال'],
            ['name' => 'خدمات سيارات'],
            ['name' => 'تأجير سيارات'],
            ['name' => 'قطع غيار وإكسسوارات'],
            ['name' => 'سوبر ماركت وبقالة'],
            ['name' => 'خدمات توصيل'],
            ['name' => 'مغاسل ملابس'],
            ['name' => 'خدمات تعليمية وتدريب'],
            ['name' => 'سفر وسياحة'],
            ['name' => 'خدمات منزلية (صيانة ونظافة)'],
        ];

        // إضافة الفئات إلى قاعدة البيانات
        foreach ($categories as $category) {
            Category::create($category);
        }
    }
}
