<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('password_reset_tokens', function (Blueprint $table) {
            // --- **هذه هي الإضافات المهمة** ---

            // 1. عمود البريد الإلكتروني
            $table->string('email')->primary(); // ->primary() يجعله المفتاح الأساسي ويضمن عدم تكراره

            // 2. عمود الرمز
            $table->string('token');

            // 3. عمود تاريخ الإنشاء
            $table->timestamp('created_at')->nullable();

            // **ملاحظة:** لا نحتاج إلى عمود id أو timestamps هنا
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('password_reset_tokens');
    }
};
