<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('profile_update_requests', function (Blueprint $table) {
            // ==========================================================
            //  **الإصلاح الحاسم هنا: إضافة الأعمدة المفقودة**
            // ==========================================================
            $table->uuid('processed_by')->nullable()->after('status'); // لحفظ ID الأدمن
            $table->timestamp('processed_at')->nullable()->after('processed_by'); // لحفظ وقت المعالجة

            // ربط العمود مع جدول المستخدمين (الأدمن)
            $table->foreign('processed_by')->references('id')->on('users')->onDelete('set null');
        });
    }

    public function down(): void
    {
        Schema::table('profile_update_requests', function (Blueprint $table) {
            $table->dropForeign(['processed_by']);
            $table->dropColumn(['processed_by', 'processed_at']);
        });
    }
};
