<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    // داخل ملف database/migrations/xxxx_xx_xx_xxxxxx_create_store_update_requests_table.php

    public function up(): void
    {
        Schema::create('store_update_requests', function (Blueprint $table) {
            $table->id();
            $table->foreignUuid('user_id')->constrained('users')->onDelete('cascade'); // معرف المتجر
            $table->json('old_data'); // البيانات القديمة بصيغة JSON
            $table->json('new_data'); // البيانات الجديدة المقترحة بصيغة JSON
            $table->enum('status', ['pending', 'approved', 'rejected'])->default('pending'); // حالة الطلب
            $table->text('rejection_reason')->nullable(); // سبب الرفض (إذا تم الرفض)
            $table->foreignUuid('processed_by')->nullable()->constrained('users'); // من هو الأدمن الذي عالج الطلب
            $table->timestamp('processed_at')->nullable(); // متى تمت معالجة الطلب
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('store_update_requests');
    }
};
