<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('invoice_product', function (Blueprint $table) {
            // لا نحتاج إلى id هنا، المفتاح الأساسي مركب

            // المفتاح الخارجي لجدول الفواتير
            $table->foreignId('invoice_id')->constrained()->onDelete('cascade');

            // المفتاح الخارجي لجدول المنتجات
            $table->foreignId('product_id')->constrained()->onDelete('cascade');

            // تعريف المفتاح الأساسي المركب لضمان عدم تكرار نفس المنتج في نفس الفاتورة
            $table->primary(['invoice_id', 'product_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('invoice_product');
    }
};
