<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('transactions', function (Blueprint $table) {
            // إضافة عمود لتسجيل هوية العميل الذي حصل على الكاش باك
            $table->uuid('customer_id')->nullable()->after('user_id');

            // إضافة عمود لتسجيل المنتج المرتبط بالمعاملة
            $table->foreignId('product_id')->nullable()->constrained()->onDelete('set null')->after('customer_id');

            // إضافة عمود لتسجيل قيمة الفاتورة الإجمالية
            $table->decimal('invoice_amount', 10, 2)->nullable()->after('amount');

            // إضافة عمود لتخزين رابط صورة الفاتورة
            $table->string('invoice_image_url')->nullable()->after('description');

            // إضافة عمود لتسجيل عمولة المحيل
            $table->decimal('referrer_bonus', 10, 2)->default(0)->after('invoice_amount');
        });
    }

    public function down(): void
    {
        Schema::table('transactions', function (Blueprint $table) {
            $table->dropForeign(['product_id']);
            $table->dropColumn([
                'customer_id',
                'product_id',
                'invoice_amount',
                'invoice_image_url',
                'referrer_bonus',
            ]);
        });
    }
};
