<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    // في ملف الـ migration الجديد

    public function up(): void
    {
        Schema::table('transactions', function (Blueprint $table) {
            // السماح لهذه الحقول بأن تكون فارغة
            $table->string('related_type')->nullable()->change();
            $table->uuid('related_id')->nullable()->change();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('transactions', function (Blueprint $table) {
            $table->string('related_type')->nullable(false)->change();
            $table->uuid('related_id')->nullable(false)->change();
        });
    }
};
