<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('transactions', function (Blueprint $table) {
            $table->id();
            $table->foreignUuid('user_id')->constrained('users')->onDelete('cascade'); // المستخدم صاحب المعاملة
            $table->string('type'); // نوع المعاملة (e.g., 'cashback_earned', 'referral_bonus', 'withdrawal')
            $table->decimal('amount', 10, 2); // قيمة المعاملة
            $table->text('description'); // وصف للمعاملة (e.g., "Cashback from Store X")
            $table->morphs('related'); // لربط المعاملة بكيان آخر (مثل فاتورة أو طلب سحب)
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('transactions');
    }
};
