<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('store_profiles', function (Blueprint $table) {
            $table->id();
            $table->foreignUuid('store_id')->constrained('users')->onDelete('cascade'); // الربط بحساب المتجر في جدول users
            $table->foreignId('category_id')->nullable()->constrained('categories')->onDelete('set null'); // الربط بجدول الفئات
            $table->text('description')->nullable();
            $table->string('country')->nullable();
            $table->string('city')->nullable();
            $table->string('address')->nullable();
            $table->decimal('latitude', 10, 7)->nullable(); // خط العرض
            $table->decimal('longitude', 10, 7)->nullable(); // خط الطول
            $table->string('profile_image_url')->nullable();
            $table->string('cover_image_url')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('store_profiles');
    }
};
