<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('users', function (Blueprint $table) {
            $table->uuid('id')->primary(); // استخدام UUID كمفتاح أساسي
            $table->string('name');
            $table->string('email')->unique();
            $table->string('phone')->unique(); // <-- السطر الجديد
            $table->timestamp('email_verified_at')->nullable();
            $table->string('password');
            $table->string('role')->default('user'); // الأدوار: user, store, admin
            $table->string('status')->default('pending'); // الحالات: pending, active, suspended
            $table->string('referral_code')->unique();
            $table->foreignUuid('referrer_id')->nullable()->constrained('users')->onDelete('set null');
            $table->string('qr_code_data')->nullable();
            $table->rememberToken();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('users');
    }
};
