<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Authentication Defaults
    |--------------------------------------------------------------------------
    |
    | هذا الخيار يحدد الـ "guard" الافتراضي. سنتركه 'web' للمحافظة على
    | التوافقية، ولكننا سنعتمد على middleware لتحديد الـ guard الصحيح للـ API.
    |
    */

    'defaults' => [
        'guard' => 'web',
        'passwords' => 'users',
    ],

    /*
    |--------------------------------------------------------------------------
    | Authentication Guards
    |--------------------------------------------------------------------------
    |
    | هنا نحدد كل الـ guards المتاحة في التطبيق.
    | قمنا بإضافة guard جديد اسمه 'api' وهو الأهم لمشروعنا.
    |
    */

    'guards' => [
        'web' => [
            'driver' => 'session',
            'provider' => 'users',
        ],

        // هذا هو الـ Guard الذي سيستخدمه Sanctum للتحقق من الـ Tokens
        'api' => [
            'driver' => 'sanctum',
            'provider' => 'users',
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | User Providers
    |--------------------------------------------------------------------------
    |
    | هنا نحدد كيف يتم جلب بيانات المستخدمين من قاعدة البيانات.
    | الإعداد الافتراضي باستخدام Eloquent و App\Models\User مناسب تمامًا.
    |
    */

    'providers' => [
        'users' => [
            'driver' => 'eloquent',
            'model' => App\Models\User::class,
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Resetting Passwords
    |--------------------------------------------------------------------------
    |
    | إعدادات إعادة تعيين كلمة المرور.
    |
    */

    'passwords' => [
        'users' => [
            'provider' => 'users',
            'table' => 'password_reset_tokens',
            'expire' => 60,
            'throttle' => 60,
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Password Confirmation Timeout
    |--------------------------------------------------------------------------
    |
    | مدة صلاحية تأكيد كلمة المرور.
    |
    */

    'password_timeout' => env('AUTH_PASSWORD_TIMEOUT', 10800),

];
