<?php

use Illuminate\Foundation\Application;
use Illuminate\Foundation\Configuration\Exceptions;
use Illuminate\Foundation\Configuration\Middleware;
use Illuminate\Http\Request; // <-- 1. إضافة استيراد Request

return Application::configure(basePath: dirname(__DIR__))
    ->withRouting(
        web: __DIR__.'/../routes/web.php',
        api: __DIR__.'/../routes/api.php',
        commands: __DIR__.'/../routes/console.php',
        health: '/up',
    )
    ->withMiddleware(function (Middleware $middleware) {
        // تسجيل الأسماء المستعارة للـ Middlewares المخصصة (الكود الخاص بك)
        $middleware->alias([
            'auth.admin' => \App\Http\Middleware\IsAdmin::class,
            'auth.store' => \App\Http\Middleware\IsStore::class,
        ]);

        // ==========================================================
        //  2. الإصلاح الرئيسي والنهائي هنا
        //  إخبار Laravel بعدم إعادة التوجيه لطلبات الـ API
        // ==========================================================
        $middleware->redirectGuestsTo(function (Request $request) {
            if ($request->is('api/*')) {
                return null; // لا تقم بإعادة التوجيه، بل أرجع خطأ 401
            }

            // حافظ على السلوك الافتراضي لطلبات الويب (لن نستخدمه)
            return route('login');
        });
    })
    ->withExceptions(function (Exceptions $exceptions) {
        // التعامل مع الأخطاء كـ JSON لطلبات الـ API (الكود الخاص بك)
        $exceptions->shouldRenderJsonWhen(function ($request, $e) {
            return $request->is('api/*');
        });
    })->create();
