<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class WithdrawalRequestProcessed extends Notification
{
    use Queueable;

    protected $message;

    /**
     * Create a new notification instance.
     */
    public function __construct($message)
    {
        $this->message = $message;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return ['database'];
    }

    /**
     * Get the database representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toDatabase(object $notifiable): array
    {
        // ==========================================================
        //  الإصلاح الرئيسي هنا:
        //  يجب أن يكون اسم الدالة toDatabase() وليس toArray()
        //  عند استخدام قناة 'database'.
        // ==========================================================
        return [
            'title' => 'تحديث بشأن طلب السحب',
            'body' => $this->message,
            // Laravel سيضيف الحقول الأخرى (id, type, user_id, timestamps) تلقائيًا
        ];
    }
}
