<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Concerns\HasUuids; // <-- مهم جدًا لـ UUID
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;

class User extends Authenticatable
{
    // استخدام الـ Traits الصحيحة
    use HasApiTokens, HasFactory, HasUuids, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'id',               // للسماح بتعيين الـ UUID يدويًا
        'name',
        'email',
        'password',
        'phone',            // <-- تم إصلاح المشكلة: إضافة حقل الهاتف
        'role',
        'status',
        'referrer_id',
        'referral_code',
        'qr_code_data',     // <-- إضافة حقل رمز الاستجابة السريعة
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
        'password' => 'hashed',
    ];

    // =================================================================
    // العلاقات (Relationships)
    // =================================================================

    public function storeProfile()
    {
        return $this->hasOne(StoreProfile::class, 'store_id', 'id');
    }

    public function wallet()
    {
        return $this->hasOne(Wallet::class, 'user_id');
    }

    // علاقة لجلب المُحيل الخاص بالمستخدم (الشخص الذي دعاه)
    public function referrer()
    {
        return $this->belongsTo(User::class, 'referrer_id');
    }

    // علاقة لجلب المستخدمين الذين قام هذا المستخدم بدعوتهم
    public function referrals()
    {
        return $this->hasMany(User::class, 'referrer_id');
    }

    public function transactions()
    {
        return $this->hasMany(Transaction::class);
    }

    public function withdrawalRequests()
    {
        return $this->hasMany(WithdrawalRequest::class);
    }

    public function notifications()
    {
        return $this->hasMany(Notification::class);
    }

    public function products()
    {
        return $this->hasMany(Product::class, 'store_id', 'id');
    }
        public function profileUpdateRequests()
    {
        return $this->hasMany(ProfileUpdateRequest::class, 'store_id');
    }
}
