<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Transaction extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'amount',
        'type', // e.g., 'deposit', 'withdrawal', 'cashback'
        'description',
        'status', // e.g., 'completed', 'pending', 'failed'
        'related_id',   // For linking to other models (e.g., WithdrawalRequest ID)
        'related_type', // For linking to other models (e.g., 'App\Models\WithdrawalRequest')
    ];

    public function relatedInvoice()
    {
        return $this->belongsTo(Invoice::class, 'related_id');
    }

    public function wallet()
    {
        return $this->belongsTo(Wallet::class);
    }

    public function related()
    {
        return $this->morphTo();
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
