<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class StoreUpdateRequest extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'store_id',
        'pending_data', // البيانات الجديدة التي يريد المتجر تحديثها (بصيغة JSON)
        'status',       // (pending, approved, rejected)
        'admin_notes',  // ملاحظات الأدمن عند الرفض أو الموافقة
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array
     */
    protected $casts = [
        'pending_data' => 'array', // تحويل JSON إلى مصفوفة تلقائيًا
    ];

    /**
     * علاقة لجلب المتجر (المستخدم) صاحب هذا الطلب.
     */
    public function store()
    {
        return $this->belongsTo(User::class, 'store_id');
    }
}
