<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Storage;

class StoreProfile extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'category_id',
        'description',
        'country',
        'city',
        'address',
        'latitude',
        'longitude',
        'cashback_percentage_all',
        'profile_image_url',
        'cover_image_url',
    ];

    // ==========================================================
    // **الإصلاح الحاسم والنهائي هنا**
    // **جعل الأسماء في $appends مطابقة لأسماء الدوال**
    // ==========================================================
    protected $appends = [
        'full_profile_image_url', // <-- **تم التعديل هنا**
        'full_cover_image_url',   // <-- **تم التعديل هنا**
    ];

    /**
     * علاقة لجلب المستخدم (المتجر) صاحب هذا الملف الشخصي.
     */
    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    /**
     * علاقة لجلب الفئة التي ينتمي إليها المتجر.
     */
    public function category()
    {
        return $this->belongsTo(Category::class);
    }

    // --- Accessors لجلب الروابط الكاملة للصور ---

    public function getFullProfileImageUrlAttribute(): ?string
    {
        if ($this->profile_image_url) {
            // استخدام دالة asset() لإنشاء الرابط الكامل الصحيح
            return asset('storage/' . $this->profile_image_url);
        }
        return null;
    }

    public function getFullCoverImageUrlAttribute(): ?string
    {
        if ($this->cover_image_url) {
            return asset('storage/' . $this->cover_image_url);
        }
        return null;
    }
}
