<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ProfileUpdateRequest extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'store_id',
        'pending_data',
        'status',
        'admin_notes',
        'processed_by',
        'processed_at',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array
     */
    protected $casts = [
        'pending_data' => 'array',
        'processed_at' => 'datetime',
        
        // ==========================================================
        // **الإصلاح الحاسم والنهائي هنا**
        // **إجبار Laravel على التعامل مع 'status' كنص (string)**
        // ==========================================================
        'status' => 'string', // <-- هذا هو السطر الذي سيحل المشكلة
    ];

    /**
     * علاقة لجلب المتجر (المستخدم) صاحب هذا الطلب.
     */
    public function store()
    {
        return $this->belongsTo(User::class, 'store_id');
    }
}
