<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany; // **1. تأكد من استيراد HasMany**
use Illuminate\Database\Eloquent\SoftDeletes;

class Invoice extends Model
{
    use HasFactory, SoftDeletes; // **2. استخدام الـ Trait هنا**


    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'store_id',
        'user_id',
        'total_amount',
        'cashback_percentage',
        'cashback_amount',
        'invoice_image_url',
        'notes',
    ];

    /**
     * The products that belong to the invoice.
     */
    public function products()
    {
        return $this->belongsToMany(Product::class);
    }

    /**
     * Get the user that owns the invoice.
     */
    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    /**
     * Get the store that created the invoice.
     */
    public function store()
    {
        return $this->belongsTo(User::class, 'store_id');
    }

    // ==========================================================
    //  **الإصلاح الحاسم والنهائي هنا: إضافة Accessor لبناء الرابط**
    //  هذه الدالة ستقوم تلقائيًا بتحويل المسار النسبي إلى رابط كامل
    //  في كل مرة يتم فيها طلب 'invoice_image_url'.
    // ==========================================================
    public function getInvoiceImageUrlAttribute($value)
    {
        // إذا كانت القيمة موجودة، قم ببناء الرابط الكامل باستخدام asset()
        // وإلا، أرجع null
        return $value ? asset($value) : null;
    }
    
    public function transactions(): HasMany
    {
        // تفترض هذه العلاقة أن جدول 'transactions' يحتوي على عمود 'invoice_id'
        return $this->hasMany(Transaction::class, 'invoice_id');
    }
}
