<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class IsStore
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        // تحقق مما إذا كان المستخدم مسجلاً دخوله ولديه دور 'store'
        if ($request->user() && $request->user()->role === 'store') {
            // إذا كان متجرًا، اسمح للطلب بالمرور
            return $next($request);
        }

        // إذا لم يكن متجرًا، أرجع رسالة خطأ "غير مصرح به"
        return response()->json(['message' => 'Unauthorized. Store access required.'], 403);
    }
}
