<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class IsAdmin
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        // تحقق مما إذا كان المستخدم مسجلاً دخوله وأن دوره هو 'admin'
        if (auth()->check() && auth()->user()->role === 'admin') {
            // إذا كان أدمن، اسمح للطلب بالمرور إلى الخطوة التالية (الـ Controller)
            return $next($request);
        }

        // إذا لم يكن أدمن، أرجع رسالة خطأ "غير مصرح به"
        return response()->json(['message' => 'Unauthorized. Admin access required.'], 403); // 403 Forbidden
    }
}
