<?php

namespace App\Http\Controllers\Api\V1\Admin;

use App\Http\Controllers\Controller;
use App\Models\Category;
use App\Models\StoreProfile;

class AdminDataController extends Controller
{
    /**
     * جلب جميع الفئات للمشرف.
     * هذه الدالة ترجع البيانات بتنسيق متوافق مع شاشة "إضافة متجر".
     */
    public function getCategories()
    {
        $categories = Category::select(['id', 'name'])->get();

        // نرجع البيانات مغلفة داخل مفتاح 'data' كما يتوقع تطبيق Flutter
        return response()->json(['data' => $categories]);
    }

    public function getStores(Request $request)
    {
        // جلب جميع المستخدمين الذين دورهم "متجر" مع تحميل بياناتهم الشخصية والفئة
        $stores = User::where('role', 'store')
            ->with(['storeProfile.category'])
            ->latest() // عرض الأحدث أولاً
            ->paginate(15); // تقسيم النتائج إلى صفحات لضمان الأداء

        return response()->json($stores);
    }

    /**
     * جلب جميع الدول للمشرف.
     */
    public function getCountries()
    {
        $countries = StoreProfile::query()
            ->whereNotNull('country')
            ->where('country', '!=', '')
            ->distinct()
            ->pluck('country');

        // نرجع البيانات كقائمة مباشرة
        return response()->json($countries);
    }
}
