<?php

namespace App\Http\Controllers\Api\V1\Admin;

use App\Http\Controllers\Controller;
use App\Models\User;
use App\Models\WithdrawalRequest;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cache;

class AdminDashboardController extends Controller
{
    /**
     * جلب الإحصائيات الرئيسية للوحة تحكم المشرف.
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function getStats(Request $request)
    {
        // استخدام الكاش لمدة 5 دقائق لتقليل الضغط على قاعدة البيانات
        // يمكن تعديل المدة حسب الحاجة
        $stats = Cache::remember('admin_dashboard_stats', now()->addMinutes(5), function () {

            // 1. إحصائيات المستخدمين
            $totalUsers = User::where('role', 'user')->count();

            // 2. إحصائيات المتاجر
            $storesQuery = User::where('role', 'store');
            $totalStores = $storesQuery->count();
            $activeStores = (clone $storesQuery)->where('status', 'active')->count();

            // 3. إحصائيات طلبات السحب
            $pendingWithdrawals = WithdrawalRequest::where('status', 'pending')->count();

            return [
                'total_users' => $totalUsers,
                'total_stores' => $totalStores,
                'active_stores' => $activeStores,
                'pending_withdrawals' => $pendingWithdrawals,
            ];
        });

        return response()->json($stats);
    }
}
