<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;
use App\Models\StoreProfile;
use App\Models\User;

class UpdateStoreAverageCashback extends Command
{
    protected $signature = 'stores:update-cashback-average';
    protected $description = 'Calculates and updates the average cashback percentage for all stores.';

    public function handle()
    {
        $this->info('Starting to update average cashback for all stores...');

        $stores = User::where('role', 'store')->get();

        foreach ($stores as $store) {
            $averageCashback = DB::table('products')
                                 ->where('store_id', $store->id)
                                 ->avg('cashback_percentage');

            if ($averageCashback !== null) {
                StoreProfile::updateOrCreate(
                    ['store_id' => $store->id],
                    ['cashback_percentage_all' => $averageCashback]
                );
                $this->line("Updated store '{$store->name}' with average cashback: " . number_format($averageCashback, 2) . '%');
            } else {
                StoreProfile::updateOrCreate(
                    ['store_id' => $store->id],
                    ['cashback_percentage_all' => 0]
                );
                $this->line("Store '{$store->name}' has no products. Set average cashback to 0%.");
            }
        }

        $this->info('Successfully updated average cashback for all stores.');
        return 0;
    }
}
